#include <iostream>
#include <fstream>
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <iomanip>
#include <algorithm>
#include <queue>

#define TASK "important"

#define MAX_N 20000
#define MAX_M 100000

using namespace std;

typedef long long ll;


int n;

vector<pair<pair<int, int>, int> > e[MAX_N];



ll dist[MAX_N];
vector<pair<int, int> > back[MAX_N];


bool visited[MAX_N];

void dijkstra() {
	priority_queue<pair<ll, int> > pq;
	
	dist[0] = 0;
	for (int i = 1; i < n; ++i) {
		dist[i] = -1;
	}
	int now = 0;
	while (now != -1) {
		//cout << now+1 << endl;
		visited[now] = true;
		for (int i = 0; i < e[now].size(); ++i) {
			int next = e[now][i].first.first;
			int nDist = dist[now] + e[now][i].first.second;
			if (dist[next] == -1 || nDist <= dist[next]) {
				if (dist[next] == -1 || nDist < dist[next]) {
					dist[next] = nDist;
					back[next].clear();
					pq.push(make_pair(-nDist, next));
				}
				back[next].push_back(make_pair(now, e[now][i].second));
			}
		}

		now = -1;
		while (now == -1 && !pq.empty()) {
			pair<ll, int> *pair = &pq.top();
			if (!visited[pair->second])
				now = pair->second;
			pq.pop();
		}
	}

}

struct Comp {
	bool operator()(const int &a, const int &b) {
		return dist[a] < dist[b];
	}
};

int getEnd(int start) {
	//set<int> nodes;
	priority_queue<int, vector<int>,  Comp> pq;
	set<int> s;
	pq.push(start);
	s.insert(start);
	bool first = true;
	while (true) {
		int now = pq.top();
		pq.pop();
		if (!first && pq.empty()) {
			return now;
		}
		first = false;
		for (int i = 0; i < back[now].size(); ++i) {
			int next = back[now][i].first;
			if (s.find(next) == s.end()) {
				s.insert(next);
				pq.push(next);
			}
		}
	}
}

vector<int> important;

void find() {
	//cout << "finding" << endl;
	int now = n-1;
	while (now != 0) {
		//cout << "now = " << now << endl;
		if (back[now].size() == 1) {
			important.push_back(back[now][0].second);
			//cout << "important V : " << now+1 << " " << back[now][0].first+1 << endl;
			//cout << "important NR: " << back[now][0].second << endl;
			now = back[now][0].first;
		}
		else {
			now = getEnd(now);
		}
	}
}

int main() {
	//freopen(TASK".in", "r", stdin);
	//freopen(TASK".out", "w", stdout);

	int m;
	cin >> n >> m;
	for (int i = 0; i < m; ++i) {
		int a, b, v;
		cin >> a >> b >> v;
		a--; b--;
		e[a].push_back(make_pair(make_pair(b, v), i+1));
		e[b].push_back(make_pair(make_pair(a, v), i+1));
	}

	//remove multiple edges
	for (int i = 0; i < n; ++i) {
		
	}

	dijkstra();
	find();

	/*
	for (int i = 0; i < n; ++i) {
		cout << i+1 << ":";
		for (int j = 0; j < back[i].size(); ++j)
			cout << " " << back[i][j].first+1;
		cout << endl;
	}
	*/
	
	cout << important.size() << endl;
	for (int i = 0; i < important.size(); ++i) {
		if (i)
			cout << ' ';
		cout << important[i];
	}
	cout << endl;


	return 0;
}